/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.convenientdecor.block.blockentity;

import com.github.mim1q.convenientdecor.block.WeatherVaneBlock;
import com.github.mim1q.convenientdecor.init.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ServerLevelData;

public class WeatherVaneBlockEntity
extends BlockEntity {
    private static final float BASE_MAX_VELOCITY = 0.5f;
    private static final float BASE_ACCELERATION = 0.35f;
    private float lastYaw = 0.0f;
    private float yaw = RandomSource.m_216327_().m_188501_() * 360.0f;
    private float acceleration = 0.0f;
    private float maxVelocity = 0.0f;
    private float velocity = 0.0f;

    public WeatherVaneBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.WEATHER_VANE, pos, state);
    }

    public void tick(Level world, BlockPos pos, BlockState state) {
        float nextVelocity;
        int multiplier = (Integer)state.m_61143_((Property)WeatherVaneBlock.POWER) + 1;
        if (!world.f_46443_ && world.m_46467_() % 20L == 0L) {
            this.updatePower((ServerLevel)world, state);
            this.m_6596_();
            return;
        }
        RandomSource rng = world.m_213780_();
        if (world.m_46467_() % 20L == 0L && rng.m_188501_() < 0.25f * (float)multiplier) {
            this.maxVelocity = rng.m_188501_() * 0.5f * (float)multiplier;
            this.acceleration = (rng.m_188499_() ? -1.0f : 1.0f) * (0.35f * rng.m_188501_());
        }
        this.velocity = Math.abs(nextVelocity = this.velocity + this.acceleration * (float)multiplier) > this.maxVelocity * (float)multiplier ? this.maxVelocity * (float)multiplier * Math.signum(nextVelocity) : nextVelocity;
        this.lastYaw = this.yaw;
        this.yaw += this.velocity;
        this.acceleration *= 0.9f;
        this.velocity *= 0.95f;
    }

    public void updatePower(ServerLevel world, BlockState state) {
        int power = (Boolean)state.m_61143_((Property)WeatherVaneBlock.FORECAST_MODE) != false ? WeatherVaneBlockEntity.getWeatherPredictionStrength(world, ((WeatherVaneBlock)state.m_60734_()).timeUnit) : WeatherVaneBlockEntity.getStrengthFromWeather(world);
        int lastPower = (Integer)state.m_61143_((Property)WeatherVaneBlock.POWER);
        world.m_46597_(this.m_58899_(), (BlockState)state.m_61124_((Property)WeatherVaneBlock.POWER, (Comparable)Integer.valueOf(power)));
        if (power != lastPower) {
            world.m_6289_(this.m_58899_(), this.m_58900_().m_60734_());
            world.m_6289_(this.m_58899_().m_7495_(), this.m_58900_().m_60734_());
        }
    }

    public static int getWeatherPredictionStrength(ServerLevel world, int timeUnit) {
        ServerLevelData properties = (ServerLevelData)world.m_6106_();
        if (world.m_46471_() || properties.m_6537_() == 0) {
            return WeatherVaneBlockEntity.getStrengthFromRemainingTime(properties.m_6531_(), timeUnit);
        }
        return WeatherVaneBlockEntity.getStrengthFromRemainingTime(properties.m_6537_(), timeUnit);
    }

    public static int getStrengthFromRemainingTime(float remainingTime, int timeUnit) {
        int timeUnits = (int)(remainingTime / (float)timeUnit) + 1;
        return Mth.m_14045_((int)(16 - timeUnits), (int)0, (int)15);
    }

    public static int getStrengthFromWeather(ServerLevel world) {
        if (world.m_46470_()) {
            return 15;
        }
        if (world.m_46471_()) {
            return 7;
        }
        return 0;
    }

    public float getYaw(float tickDelta) {
        return this.lastYaw + tickDelta * (this.yaw - this.lastYaw);
    }
}

